#NoEnv
SetWorkingDir %A_ScriptDir%  
#Include %A_ScriptDir%
#Include windows.ahk
#Include FlashSpacesGui(alternatingGUIs).ahk
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Auto timers, usefull when debugging  ;
; turn off or set high to save cpu     ;
; when debug is done                   ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

SetTimer,AutoReloadScript,1000

; ***** initialization *****
#WinActivateForce
SetBatchLines, -1   ; maximize script speed!
SetWinDelay, -1

OnExit, CleanUp     ; clean up in case of error (otherwise some windows will get lost)
numDesktops := 4    ; maximum number of desktops
return

;===== HOTKEYS =====
{
;numbers
CapsLock & 0::
	exitApp
return

CapsLock & r::
if GetKeyState("Space")
{
	msgbox I shall reload
	reload
}
return


CapsLock & 1::
	if !GetKeyState("LWin")
		SwitchToDesktop(1)
	else
		SendActiveToDesktop(1)
return

CapsLock & 2::
	if !GetKeyState("LWin")
		SwitchToDesktop(2)
	else
		SendActiveToDesktop(2)
return

CapsLock & 3::
	if !GetKeyState("LWin")
		SwitchToDesktop(3)
	else
		SendActiveToDesktop(3)
return

CapsLock & 4::
	if !GetKeyState("LWin")
		SwitchToDesktop(4)
	else
		SendActiveToDesktop(4)
return



;arrows
CapsLock & Left::
	if !GetKeyState("LWin") {
		newDesktop := DetermineNewDesktop("l")
		if (newDesktop != 0)
			SwitchToDesktop(newDesktop)
	}
	else {
		newDesktop := determineNewDesktop("l")
		if (newDesktop != 0)
			SendActiveToDesktop(newDesktop)
	}
return

CapsLock & Right::
	if !GetKeyState("LWin") {
		newDesktop := DetermineNewDesktop("r")
		if (newDesktop != 0)
			SwitchToDesktop(newDesktop)
	}
	else {
		newDesktop := determineNewDesktop("r")
		if (newDesktop != 0)
			SendActiveToDesktop(newDesktop)
	}
return

CapsLock & Up::
	if !GetKeyState("LWin") {
		newDesktop := DetermineNewDesktop("u")
		if (newDesktop != 0)
			SwitchToDesktop(newDesktop)
	}
	else {
		newDesktop := determineNewDesktop("u")
		if (newDesktop != 0)
			SendActiveToDesktop(newDesktop)
	}
return

CapsLock & Down::
	if !GetKeyState("LWin") {
		newDesktop := DetermineNewDesktop("d")
		if (newDesktop != 0)
			SwitchToDesktop(newDesktop)
	}
	else {
		newDesktop := determineNewDesktop("d")
		if (newDesktop != 0)
			SendActiveToDesktop(newDesktop)
	}
return







CapsLock & Space::
	msgbox not programmed yet
	;keyWait, Space
	;sleep 1000
	;if (A_ThisHotkey = "CapsLock & Space")	;if the user hasn't activated any other hotkeys during the sleep period
		;msgbox Pressing ^Space will display a grand view of all spaces...or something
return

CapsLock & d::
	ControlGet, HWND, Hwnd,, SysListView321, ahk_class Progman
	If HWND =
		ControlGet, HWND, Hwnd,, SysListView321, ahk_class WorkerW
	If DllCall("IsWindowVisible", UInt, HWND)
		WinHide, ahk_id %HWND%
	Else {
		WinShow, ahk_id %HWND%
		SetTimer, hideIcons, -30000
	}
	SetCapsLockState off
   
Return

hideIcons:
	ControlGet, HWND, Hwnd,, SysListView321, ahk_class Progman
	If HWND =
		ControlGet, HWND, Hwnd,, SysListView321, ahk_class WorkerW
	WinHide, ahk_id %HWND%

CapsLock::
SetCapsLockState off
return

;debugging
!0::ExitApp
} ;end of HOTKEYS section

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; AutoScriptReload/Suspend ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AutoReloadScript:
   FileGetAttrib,attribs,%A_ScriptFullPath%
   IfInString,attribs,A
   {
      FileSetAttrib,-A,%A_ScriptFullPath%
	  msgbox Reloading.
	  Reload
   }
return 


;===== FUNCTIONS =====
SwitchToDesktop(newDesktop) 
{
   global

   if (curDesktop <> newDesktop)
   {
	  enableHotkeys(false)
	  ;sleep 1000
	  flashSpacesGui(curDesktop,newDesktop)
	  ;msgbox begin %curDesktop% --> %newDesktop%
	  windows_storeCurrentWindows(curDesktop) ;GetCurrentWindows(curDesktop) ;
      windows_hideWindows(curDesktop)	;ShowHideWindows(curDesktop, false)	;hide current windows
	  windows_showWindows(newDesktop)	;ShowHideWindows(newDesktop, true)		;show new windows
      windows_activateCorrectWindow(newDesktop)
	  ;msgbox end %curDesktop% --> %newDesktop%
	  curDesktop := newDesktop
	  ;sleep 1000
	  enableHotkeys(true)

	SetTimer, delayExit, -1000	;wait 1000ms and then destroy the gui. This has to be a separate thread.
	;tooltip
	
   }
   return
   ;JON SMITHERS______instead I would put:
   ;GetCurrentPositions(curDesktop)  ...store them into an array
   ;Exit current windows 
	  ;(move a list of windows symotaneously a fixed distance. The same function can be moving them out, or moving them in. It just has to know which direction to move them)
   ;Position the entering windows using the array
   ;Enter windows of newDesktop
		;activate top window
		;question...how will full screen work? I'm afraid it won't from testing gmail
}
	
;(determines which is the new Desktop based on which arrow key is pressed and which is the current desktop
DetermineNewDesktop(arrow)
{
	global curDesktop
	
	if (arrow = "r")
		newDesktop := curDesktop + 1
	else if (arrow = "l")
		newDesktop := curDesktop - 1
	else if (arrow = "u")
		newDesktop := curDesktop - 2
	else if (arrow = "d")
		newDesktop := curDesktop + 2
	
	if (newDesktop < 1)
		newDesktop := 0 ;newDesktop := newDesktop + 4
	else if (newDesktop > 4)
		newDesktop := 0	;newDesktop := newDesktop - 4
	return newDesktop
}

enableHotkeys(boolean)
{
	
	if !boolean
	{
		;global newDesktop, global curDesktop
		;tooltip hotkeys disabled. `r(%curDesktop%)-->(%newDesktop%)
		;Hotkey, ^1, Off
		;Hotkey, ^2, Off
		;Hotkey, ^3, Off
		;Hotkey, ^4, Off
		;Hotkey, CapsLock & Left, Off
		;Hotkey, CapsLock & Right, Off
		;Hotkey, CapsLock & Up, Off
		Hotkey, CapsLock & Down, Off
	}
	else if boolean
	{
		;global newDesktop, global curDesktop
		;tooltip hotkeys enabled. `r(%curDesktop%)-->(%newDesktop%)
		;Hotkey, ^1, On,		T1 B P99		;1 thread, buffering, 2 theads, no Buffer
		;Hotkey, ^2, On,		T1 B P99
		;Hotkey, ^3, On,		T1 B P99
		;Hotkey, ^4, On,		T1 B P99
		Hotkey, CapsLock & Left, On, 	T1 B P99
		Hotkey, CapsLock & Right, On, 	T1 B P99
		Hotkey, CapsLock & Up, On, 		T1 B P99
		Hotkey, Capslock & Down, On, 	T1 B P99
	}
	else msgbox fail
	
}

;(sends the currently active window to the given desktop)
SendActiveToDesktop(newDesktop)
{
   global curDesktop
   WinGet, id, ID, A
		;msgbox curDesktop: %curDesktop% `rnewDesktop: %newDesktop%`rwindowsID: %id%
   windows_moveWindowToDesktop(id, curDesktop, newDesktop) ;SendToDesktop(id, newDesktop)   
   windows_setActiveWindow(id, newDesktop)	;bug: usually window does not activate in the moved-to desktop
   windows_autosetActiveWindow(curDesktop)	;quirky: ideally it sets the topmost window as active, but right now it sets the last-stored as active and sends AltTab
}













;~~~~~ UNUSED FUNCTIONS ~~~~~~
;(sends the given window from the current desktop to the given desktop)
SendToDesktop(windowID, newDesktop)
{
   global
   if (curDesktop <> newDesktop)
   {
   RemoveWindowID(curDesktop, windowID)

   ; add window to destination desktop
   windows%newDesktop% += 1
   i := windows%newDesktop%

   windows%newDesktop%%i% := windowID
   
   WinHide, ahk_id %windowID%
   ;TrayTip, DesktopSwitch, Window send to desktop %newDesktop%
   Tooltip, Window Send to desktop %newDesktop%

   Send, {ALT DOWN}{TAB}{ALT UP}   ; activate the right window
   }
}

;(removes the given window id from the desktop <desktopIdx>)
RemoveWindowID(desktopIdx, ID)
{
   global
   Loop, % windows%desktopIdx%	
   {
      if (windows%desktopIdx%%A_Index% = ID)
      {
         windows%desktopIdx%%A_Index%=      ;Emiel: just empty the array element, array will be emptied by next switch anyway
         Break
      }
   }
}



; show all windows from all desktops on exit
CleanUp:
Loop, %numDesktops%
   windows_showWindows(A_Index)
ExitApp 

delayExit:
	flashSpacesGuiOff()
return























; Version history:
;
; v1.14, 25 jun 2009 Emiel Witteman
; Fixed bug window disappearing when sending it to the current desktop

; v1.13, 08 sept 2008 Emiel Witteman
; Fixed bugs in array housekeeping, explained the faulty hide/show of some windows
;
; v1.12, 08 sept 2008 Emiel Witteman
; Code cleanup, removed some redundant code from previous versions.
; Added support for MultiMonTaskbar (a taskbar on a second physical screen)
; Added storing of active window per virtual desktop
; Added Traytips to inform the user what happened
;
; v1.11, 22. Nov. 2005
; Fixed bug: windows are now corrrectly activated after switching/sending
;
; v1.1, 05. Nov. 2005
; Added feature: pressing Ctrl/Alt-<index> sends the active window to the desktop <index>.
;
; v1.0, 04. Nov. 2005
; It works!
; Switching can be done using Alt-<desktop index>, e.g. Alt-1. Pressing
; Alt-0 will exit the script and show all windows from all virtual desktops
; at once.
